/*
 * Decompiled with CFR 0.152.
 */
package pl.com.insoft.cardpayment.uposeft2;

import java.util.logging.Level;
import pl.com.insoft.cardpayment.ECardPaymentException;
import pl.com.insoft.cardpayment.uposeft2.IUposEft2Callback;
import pl.com.insoft.cardpayment.uposeft2.TInfoInput;
import pl.com.insoft.cardpayment.uposeft2.TInfoOutput;
import pl.com.insoft.cardpayment.uposeft2.TPrintApprovalInput;
import pl.com.insoft.cardpayment.uposeft2.TSaleInput;
import pl.com.insoft.cardpayment.uposeft2.TSaleOutput;
import pl.com.insoft.cardpayment.uposeft2.TUposEft2Enums$EEFTClientAPI_TransactionType;

class TUposEft2Server {
    private IUposEft2Callback a;
    private final String b;
    private final mi c;
    private final mi d;
    private TInfoOutput e = null;

    public TUposEft2Server(String string, String string2, mi mi2, mi mi3) {
        this.b = string;
        this.c = mi2;
        this.d = mi3;
        String string3 = string2.equalsIgnoreCase("UposEMV") ? "eft2adapter.dll" : "eft3adapter.dll";
        String string4 = bvo.e(string) + string3;
        try {
            System.load(string4);
        }
        catch (Exception exception) {
            throw new ECardPaymentException("B\u0142\u0105d podczas \u0142adowania biblioteki " + string4, exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new ECardPaymentException("B\u0142\u0105d podczas \u0142adowania biblioteki " + string4, unsatisfiedLinkError);
        }
        catch (Throwable throwable) {
            throw new ECardPaymentException("B\u0142\u0105d typu \"throwable\" podczas \u0142adowania biblioteki " + string4, throwable);
        }
    }

    private void logStartTransaction(TSaleInput tSaleInput) {
        String string = cer.a(tSaleInput.getAmountTransaction()).a(cer.d, 2).a("0.00");
        String string2 = String.format("-> Nr syst.: %08d, kwota: %s", tSaleInput.getPOSTransactionNumber(), string);
        this.c.a(Level.FINE, string2);
        this.d.a(Level.INFO, string2);
    }

    private void logEndTransaction(TSaleOutput tSaleOutput) {
        String string = "";
        string = tSaleOutput.getRealized() ? String.format("   OK (nr karty: %s %s, nr tran.: %d, kod aut.: %s)", tSaleOutput.getCardName(), tSaleOutput.getPrimaryAccountNumber(), tSaleOutput.getTransactionNumber(), tSaleOutput.getApprovalCode()) : String.format("   Odmowa! (\"%s\", \"%s\", %s[\"%s\"], %s, %s)", tSaleOutput.getMessage_Receipt(), tSaleOutput.getPrimaryAccountNumber(), tSaleOutput.getResultCode().toString(), tSaleOutput.getResultCodeAsMessage(), tSaleOutput.getNonRealizedReason().toString(), tSaleOutput.getDeclineReason().toString());
        this.c.a(Level.FINE, string);
        this.d.a(Level.INFO, string);
    }

    private void logException(Throwable throwable) {
        String string = String.format("   Odmowa! Powa\u017cna awaria podczas transakcji.", new Object[0]);
        this.c.a(Level.SEVERE, string, throwable);
        this.d.a(Level.SEVERE, string, throwable);
    }

    TSaleOutput sale(TSaleInput tSaleInput) {
        this.logStartTransaction(tSaleInput);
        TSaleOutput tSaleOutput = new TSaleOutput(tSaleInput, TUposEft2Enums$EEFTClientAPI_TransactionType.a);
        try {
            TPrintApprovalInput tPrintApprovalInput = new TPrintApprovalInput(tSaleInput.getCashierName(), tSaleInput.getPOSNumber(), tSaleInput.getPOSTransactionNumber(), tSaleInput.getShopInfo());
            TInfoInput tInfoInput = new TInfoInput();
            this.sale(tSaleInput, tSaleOutput, tPrintApprovalInput, tInfoInput);
            this.logEndTransaction(tSaleOutput);
        }
        catch (Throwable throwable) {
            this.logException(throwable);
            throw new ECardPaymentException("Wyj\u0105tek w funkcji TUposEftServer.sale()", throwable);
        }
        return tSaleOutput;
    }

    TSaleOutput refund(TSaleInput tSaleInput) {
        this.logStartTransaction(tSaleInput);
        TSaleOutput tSaleOutput = new TSaleOutput(tSaleInput, TUposEft2Enums$EEFTClientAPI_TransactionType.b);
        try {
            TPrintApprovalInput tPrintApprovalInput = new TPrintApprovalInput(tSaleInput.getCashierName(), tSaleInput.getPOSNumber(), tSaleInput.getPOSTransactionNumber(), tSaleInput.getShopInfo());
            TInfoInput tInfoInput = new TInfoInput();
            this.refund(tSaleInput, tSaleOutput, tPrintApprovalInput, tInfoInput);
            this.logEndTransaction(tSaleOutput);
        }
        catch (Throwable throwable) {
            this.logException(throwable);
            throw new ECardPaymentException("Wyj\u0105tek w funkcji TUposEftServer.refund()", throwable);
        }
        return tSaleOutput;
    }

    void setCallbackListener(IUposEft2Callback iUposEft2Callback) {
        this.a = iUposEft2Callback;
    }

    private native void sale(TSaleInput var1, TSaleOutput var2, TPrintApprovalInput var3, TInfoInput var4);

    private native void refund(TSaleInput var1, TSaleOutput var2, TPrintApprovalInput var3, TInfoInput var4);

    native boolean operationInProgress();

    void eftCallbackStatus(String string, int n2) {
        this.a.eftCallbackStatus(new String(string), n2);
    }

    TInfoOutput eftCallbackInfo(TInfoInput tInfoInput) {
        TInfoOutput tInfoOutput = this.a.eftCallbackInfo(tInfoInput);
        this.e = new TInfoOutput(tInfoOutput);
        return this.e;
    }

    boolean eftCallbackPrintApproval(TPrintApprovalInput tPrintApprovalInput) {
        return this.a.eftCallbackPrintApproval(tPrintApprovalInput);
    }

    boolean eftCallbackClose() {
        return this.a.eftCallbackClose();
    }
}

