/*
 * Decompiled with CFR 0.152.
 */
package eu.insoft.verupdate;

import eu.insoft.verupdate.HTTPDownloadFileException;
import eu.insoft.verupdate.IDownloadFileListener;
import eu.insoft.verupdate.IDownloadFileProcess;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class HTTPDownloadFile
implements IDownloadFileProcess,
Runnable {
    public static final int STATUS_INI = 0;
    public static final int STATUS_DOWNLOADING = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_CANCELLED = 4;
    public static final int STATUS_ERROR = 5;
    private URL b;
    private File c;
    private String d = "";
    private Thread e;
    private volatile int f;
    private volatile int g;
    private volatile int h;
    private volatile Exception i;
    ArrayList a;

    public HTTPDownloadFile(String string, String string2) {
        this.a(string, string2);
    }

    public HTTPDownloadFile(String string, String string2, String string3) {
        this.d = string3;
        this.a(string, string2);
    }

    private void a(String object, String string) {
        String string2 = "http://";
        if (!((String)object).startsWith(string2)) {
            object = string2 + (String)object;
        }
        try {
            this.b = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HTTPDownloadFileException("Niepoprawny url pliku do pobrania", malformedURLException);
        }
        try {
            this.c = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new HTTPDownloadFileException("Niepoprawna specyfikacja katalogu sk\u0142adowania", nullPointerException);
        }
        this.a = new ArrayList();
        this.a();
    }

    private void a() {
        this.setStatus(0);
        this.setSize(-1);
        this.setDownloaded(0);
    }

    @Override
    public void addListener(IDownloadFileListener iDownloadFileListener) {
        if (this.a.contains(iDownloadFileListener)) {
            return;
        }
        this.a.add(iDownloadFileListener);
    }

    @Override
    public void removeListener(IDownloadFileListener iDownloadFileListener) {
        this.a.remove(iDownloadFileListener);
    }

    void a(int n2, int n3) {
        if (this.a.size() > 0) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                IDownloadFileListener iDownloadFileListener = (IDownloadFileListener)this.a.get(i2);
                iDownloadFileListener.notifyDownloadProgress(n2, n3);
            }
        }
    }

    private void a(int n2, String string) {
        if (this.a.size() > 0) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                IDownloadFileListener iDownloadFileListener = (IDownloadFileListener)this.a.get(i2);
                iDownloadFileListener.notifyDownloadStatus(n2, string);
            }
        }
    }

    private void a(Exception exception) {
        if (this.a.size() > 0) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                IDownloadFileListener iDownloadFileListener = (IDownloadFileListener)this.a.get(i2);
                iDownloadFileListener.notifyErrorException(exception);
            }
        }
    }

    public String getUrl() {
        return this.b.toString();
    }

    public synchronized Thread getThread() {
        return this.e;
    }

    public synchronized int getSize() {
        return this.f;
    }

    public synchronized void setSize(int n2) {
        this.f = n2;
    }

    public synchronized int getDownloaded() {
        return this.g;
    }

    public synchronized void setDownloaded(int n2) {
        this.g = n2;
    }

    public synchronized float getProgress() {
        return (float)this.g / (float)this.f * 100.0f;
    }

    public synchronized int getStatus() {
        return this.h;
    }

    public synchronized void setStatus(int n2) {
        this.h = n2;
        this.a(n2, this.getStatusStr());
    }

    public static String getStatusStr(int n2) {
        switch (n2) {
            case 0: {
                return "Gotowy do uruchomienia";
            }
            case 1: {
                return "Pobieranie ...";
            }
            case 2: {
                return "Pobieranie wstrzymane";
            }
            case 3: {
                return "Pobieranie zako\u0144czone";
            }
            case 4: {
                return "Pobieranie przerwane";
            }
            case 5: {
                return "Wyst\u0105pi\u0142 b\u0142\u0105d";
            }
        }
        return "";
    }

    public String getStatusStr() {
        return HTTPDownloadFile.getStatusStr(this.getStatus());
    }

    public synchronized Exception getErrorException() {
        return this.i;
    }

    public synchronized void setErrorException(Exception exception) {
        this.i = exception;
        this.a(exception);
    }

    public synchronized void start() {
        this.a();
        this.b();
    }

    public synchronized void pause() {
        this.setStatus(2);
    }

    public synchronized void resume() {
        this.b();
    }

    public synchronized void cancel() {
        this.setStatus(4);
    }

    private String a(URL uRL) {
        String string = uRL.getPath();
        return new File(string).getName();
    }

    public File getTargetPath() {
        Object object = this.a(this.b);
        String string = "";
        String string2 = "";
        if (!this.d.isEmpty()) {
            int n2 = ((String)object).lastIndexOf(".");
            if (n2 > -1) {
                string = ((String)object).substring(0, n2);
                string2 = ((String)object).substring(n2 + 1);
                object = string + "_" + this.d + "." + string2;
            } else {
                object = (String)object + "_" + this.d;
            }
        }
        return new File(this.c, (String)object);
    }

    private void b() {
        this.e = new Thread((Runnable)this, "Download task");
        this.setStatus(0);
        this.e.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        RandomAccessFile randomAccessFile = null;
        File file = null;
        InputStream inputStream = null;
        long l2 = 0L;
        try {
            byte[] byArray;
            int n2;
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.b.openConnection();
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.getDownloaded() + "-");
            httpURLConnection.connect();
            l2 = httpURLConnection.getLastModified();
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                throw new HTTPDownloadFileException("B\u0142\u0105d po\u0142\u0105czenia ze wskazanym url");
            }
            int n3 = httpURLConnection.getContentLength();
            if (n3 < 1) {
                throw new HTTPDownloadFileException("Brak pliku pod wskazanym adresem url");
            }
            if (this.getSize() == -1 || this.getSize() != this.getDownloaded() + n3) {
                this.setSize(n3);
                this.setDownloaded(0);
                this.a(0, this.getSize());
            }
            file = this.getTargetPath();
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(this.getDownloaded());
            inputStream = httpURLConnection.getInputStream();
            this.setStatus(1);
            while (this.getStatus() == 1 && (n2 = inputStream.read(byArray = new byte[65536])) != -1) {
                randomAccessFile.write(byArray, 0, n2);
                this.setDownloaded(this.getDownloaded() + n2);
                this.a(this.getDownloaded(), this.getSize());
            }
            if (this.getStatus() == 1) {
                randomAccessFile.setLength(n3);
                this.setStatus(3);
            }
        }
        catch (Exception exception) {
            this.setStatus(5);
            this.setErrorException(exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                    if (file != null && l2 != 0L) {
                        file.setLastModified(l2);
                    }
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (this.getStatus() == 5 || this.getStatus() == 4) {
                this.getTargetPath().delete();
            }
        }
    }

    @Override
    public void run() {
        this.download();
    }
}

