/*
 * Decompiled with CFR 0.152.
 */
package pl.com.insoft.pcksef.shared.ksef.model.invoice.status;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;

public class InvoiceStatusCommonModel {
    private int processingCode;
    private String processingDescription;
    private String referenceNumber;
    private String timestamp;
    private String upo;
    private String upoReferenceNumber;
    private String upoUrl;
    private String upoXml;
    private String originalSessionReferenceNumber;
    private String originalKsefNumber;

    public String getOriginalSessionReferenceNumber() {
        return this.originalSessionReferenceNumber;
    }

    public void setOriginalSessionReferenceNumber(String string) {
        this.originalSessionReferenceNumber = string;
    }

    public String getOriginalKsefNumber() {
        return this.originalKsefNumber;
    }

    public void setOriginalKsefNumber(String string) {
        this.originalKsefNumber = string;
    }

    public int getProcessingCode() {
        return this.processingCode;
    }

    public void setProcessingCode(int n2) {
        this.processingCode = n2;
    }

    public String getProcessingDescription() {
        return this.processingDescription;
    }

    public void setProcessingDescription(String string) {
        this.processingDescription = string;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String string) {
        this.referenceNumber = string;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public String getUpo() {
        return this.upo;
    }

    public void setUpo(String string) {
        this.upo = string;
    }

    public String getUpoReferenceNumber() {
        return this.upoReferenceNumber;
    }

    public void setUpoReferenceNumber(String string) {
        this.upoReferenceNumber = string;
    }

    public String getUpoUrl() {
        return this.upoUrl;
    }

    public void setUpoUrl(String string) {
        this.upoUrl = string;
    }

    public String getUpoXml() {
        this.DecodeUPO();
        return this.upoXml;
    }

    private void setUpoXml(String string) {
        this.upoXml = string;
    }

    public Date getTimestampDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            if (!this.getTimestamp().isEmpty()) {
                date = simpleDateFormat.parse(this.getTimestamp());
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public long getTimestampDateLong() {
        return this.getTimestampDate().getTime();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProcessingCode: ");
        stringBuilder.append(this.getProcessingCode());
        stringBuilder.append("\n");
        stringBuilder.append("ProcessingDescription: ");
        if (this.getProcessingDescription() != null) {
            stringBuilder.append(this.getProcessingDescription());
        }
        stringBuilder.append("\n");
        stringBuilder.append("ReferenceNumber: ");
        if (this.getReferenceNumber() != null) {
            stringBuilder.append(this.getReferenceNumber());
        }
        stringBuilder.append("\n");
        stringBuilder.append("Timestamp: ");
        if (this.getTimestamp() != null) {
            stringBuilder.append(this.getTimestamp());
        }
        stringBuilder.append("\n");
        stringBuilder.append("UPO: ");
        if (this.getUpo() != null) {
            stringBuilder.append(this.getUpo());
        }
        stringBuilder.append("\n");
        stringBuilder.append("UPOReferenceNumber: ");
        if (this.getUpoReferenceNumber() != null) {
            stringBuilder.append(this.getUpoReferenceNumber());
        }
        stringBuilder.append("\n");
        stringBuilder.append("UPOUrl: ");
        if (this.getUpoUrl() != null) {
            stringBuilder.append(this.getUpoUrl());
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private void DecodeUPO() {
        byte[] byArray = Base64.getDecoder().decode(this.getUpo().getBytes(StandardCharsets.UTF_8));
        this.setUpoXml(new String(byArray, StandardCharsets.UTF_8).toString());
    }
}

