/*
 * Decompiled with CFR 0.152.
 */
package pl.com.insoft.pcksef.shared.ksef.model.error;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import pl.com.insoft.pcksef.shared.ksef.model.error.ExceptionDetail;

public class Exception {
    private String serviceCtx;
    private String serviceCode;
    private String serviceName;
    private String timestamp;
    private String referenceNumber;
    private ArrayList exceptionDetailList = new ArrayList();

    public Exception() {
        this.setServiceCtx("");
        this.setServiceCode("");
        this.setServiceName("");
        this.setTimestamp("");
        this.setReferenceNumber("");
    }

    public ArrayList getExceptionDetailList() {
        return this.exceptionDetailList;
    }

    public String getServiceCtx() {
        return this.serviceCtx;
    }

    public void setServiceCtx(String string) {
        this.serviceCtx = string;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String string) {
        this.serviceCode = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String string) {
        this.referenceNumber = string;
    }

    public Date getTimestampDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            if (!this.getTimestamp().isEmpty()) {
                date = simpleDateFormat.parse(this.getTimestamp());
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public long getTimestampDateLong() {
        return this.getTimestampDate().getTime();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Service ctx: ");
        stringBuilder.append(this.getServiceCtx());
        stringBuilder.append("\n");
        stringBuilder.append("Service code: ");
        stringBuilder.append(this.getServiceCode());
        stringBuilder.append("\n");
        stringBuilder.append("Service name: ");
        stringBuilder.append(this.getServiceName());
        stringBuilder.append("\n");
        stringBuilder.append("Time stamp: ");
        stringBuilder.append(this.getTimestamp());
        stringBuilder.append("\n");
        stringBuilder.append("Reference number: ");
        stringBuilder.append(this.getReferenceNumber());
        stringBuilder.append("\n");
        stringBuilder.append("Szczeg\u00f3\u0142y b\u0142\u0119du:");
        stringBuilder.append("\n");
        for (ExceptionDetail exceptionDetail : this.getExceptionDetailList()) {
            stringBuilder.append("Kod: ");
            stringBuilder.append(exceptionDetail);
        }
        return stringBuilder.toString();
    }
}

