/*
 * Decompiled with CFR 0.152.
 */
package pl.com.insoft.scomanager.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import pl.com.insoft.scomanager.server.b;

@WebSocket
public class TSCOManagerServerEngine {
    protected static final String WS_ADDRESS = "/insoft/ws/scomanager";
    private final Set<Session> SESSIONS = ConcurrentHashMap.newKeySet();
    private bap log;
    private Server server;
    private uhj lastStatus;
    private uhi lastOrder;
    private List<uhb> listeners = new ArrayList<uhb>();

    TSCOManagerServerEngine(bap bap2, int n2) {
        this.log = bap2;
        this.server = new Server(n2);
        ServletContextHandler servletContextHandler = new ServletContextHandler(1);
        servletContextHandler.setContextPath("/");
        this.server.setHandler((Handler)servletContextHandler);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContextHandler, (servletContext, jettyWebSocketServerContainer) -> jettyWebSocketServerContainer.addMapping(WS_ADDRESS, (jettyServerUpgradeRequest, jettyServerUpgradeResponse) -> this));
    }

    public void start() {
        this.server.start();
        this.log.a(Level.FINE, "Serwer Mened\u017cera kas SCO uruchomiony");
    }

    public void dispose() {
    }

    public ugv getOrder() {
        return this.lastOrder;
    }

    public void clearOrder() {
        this.lastOrder = null;
    }

    public void addDeviceListener(uhb uhb2) {
        for (uhb uhb3 : this.listeners) {
            if (uhb3 != uhb2) continue;
            return;
        }
        this.listeners.add(uhb2);
    }

    public void removeDeviceListener(uhb uhb2) {
        if (this.listeners.contains(uhb2)) {
            this.listeners.remove(uhb2);
        }
    }

    public void removeAllDeviceListeners() {
        this.listeners.clear();
    }

    public void sendDeviceStatus(uhj uhj2) {
        this.lastStatus = uhj2;
        this.broadcastData(uhj2.h().toString());
    }

    public void broadcastData(String string) {
        this.log.a(Level.FINE, "-> " + string);
        for (Session session : this.SESSIONS) {
            if (session.isOpen()) {
                this.sendData(session, string, true);
                continue;
            }
            this.SESSIONS.remove(session);
        }
    }

    private void sendData(Session session, String string, boolean bl2) {
        if (bl2) {
            this.log.a(Level.FINE, "-> [" + session.getRemoteAddress().toString() + "] " + string);
        }
        session.getRemote().sendString(string, (WriteCallback)new b(this, session));
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.SESSIONS.add(session);
        this.log.a(Level.FINE, "Po\u0142\u0105czon\u0105 [" + session.getRemoteAddress().toString() + "]");
        if (this.lastStatus != null) {
            this.sendData(session, this.lastStatus.h().toString(), true);
        }
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String string) {
        uhi uhi2;
        this.log.a(Level.FINE, "<- [" + session.getRemoteAddress().toString() + "] " + string);
        this.lastOrder = uhi2 = new uhi(string);
        this.notifyDeviceListeners(uhi2);
    }

    @OnWebSocketClose
    public void onClose(Session session, int n2, String string) {
        this.SESSIONS.remove(session);
        this.log.a(Level.FINE, "Zako\u0144czenie po\u0142\u0105czenia [" + session.getRemoteAddress().toString() + "]: " + string);
    }

    @OnWebSocketError
    public void onError(Session session, Throwable throwable) {
        this.SESSIONS.remove(session);
        this.log.a(Level.FINE, "B\u0142\u0105d po\u0142\u0105czenia [" + session.getRemoteAddress().toString() + "]: " + throwable.getLocalizedMessage());
    }

    public void notifyDeviceListeners(uhi uhi2) {
        for (uhb uhb2 : this.listeners) {
            uhb2.a(uhi2);
        }
    }
}

