/*
 * Decompiled with CFR 0.152.
 */
package org.dyno.visual.swing.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JComponent;
import org.dyno.visual.swing.layouts.Alignment;
import org.dyno.visual.swing.layouts.Bilateral;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.LayoutStyle;
import org.dyno.visual.swing.layouts.Leading;
import org.dyno.visual.swing.layouts.Spring;
import org.dyno.visual.swing.layouts.Trailing;

public class GroupLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<Component, Constraints> constraints = new HashMap();

    public Constraints getConstraints(Component comp) {
        return this.constraints.get(comp);
    }

    public void setConstraints(Component comp, Constraints constraint) {
        this.constraints.put(comp, constraint);
    }

    @Override
    public void addLayoutComponent(Component comp, Object con) {
        assert (con != null && con instanceof Constraints);
        Constraints constraints = (Constraints)con;
        this.checkPreferredSize(comp, constraints);
        this.constraints.put(comp, constraints);
    }

    private void checkPreferredSize(Component comp, Constraints constraints) {
        Bilateral bilateral;
        int pref;
        Trailing trailing;
        int size;
        Leading leading;
        Dimension prefs = comp.getPreferredSize();
        Alignment axis = constraints.getHorizontal();
        if (axis instanceof Leading) {
            leading = (Leading)axis;
            size = leading.getSize();
            if (size == prefs.width) {
                leading.setSize(-1);
            }
        } else if (axis instanceof Trailing) {
            trailing = (Trailing)axis;
            size = trailing.getSize();
            if (size == prefs.width) {
                trailing.setSize(-1);
            }
        } else if (axis instanceof Bilateral && (pref = (bilateral = (Bilateral)axis).getSpring().getPreferred()) == prefs.width) {
            bilateral.getSpring().setPreferred(-1);
        }
        if ((axis = constraints.getVertical()) instanceof Leading) {
            leading = (Leading)axis;
            size = leading.getSize();
            if (size == prefs.height) {
                leading.setSize(-1);
            }
        } else if (axis instanceof Trailing) {
            trailing = (Trailing)axis;
            size = trailing.getSize();
            if (size == prefs.height) {
                trailing.setSize(-1);
            }
        } else if (axis instanceof Bilateral && (pref = (bilateral = (Bilateral)axis).getSpring().getPreferred()) == prefs.height) {
            bilateral.getSpring().setPreferred(-1);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int width = parent.getWidth();
        int height = parent.getHeight();
        Dimension min = this.minimumLayoutSize(parent);
        if (width < min.width) {
            width = min.width;
        }
        if (height < min.height) {
            height = min.height;
        }
        int count = parent.getComponentCount();
        Insets insets = parent.getInsets();
        int i2 = 0;
        while (i2 < count) {
            Component comp = parent.getComponent(i2);
            if (comp != null) {
                Trailing trailing;
                Bilateral bilateral;
                int size;
                Leading leading;
                Constraints cons = this.constraints.get(comp);
                if (cons == null) {
                    cons = this.createConstraintsFor(parent, comp);
                }
                Alignment horizontal = cons.getHorizontal();
                Alignment vertical = cons.getVertical();
                Rectangle bounds = comp.getBounds();
                Dimension prefs = comp.getPreferredSize();
                int x2 = bounds.x;
                int y2 = bounds.y;
                int w2 = bounds.width;
                int h2 = bounds.height;
                if (horizontal instanceof Leading) {
                    leading = (Leading)horizontal;
                    x2 = insets.left + leading.getLeading();
                    size = leading.getSize();
                    w2 = size == -1 ? prefs.width : size;
                } else if (horizontal instanceof Bilateral) {
                    bilateral = (Bilateral)horizontal;
                    x2 = insets.left + bilateral.getLeading();
                    w2 = width - x2 - bilateral.getTrailing() - insets.right;
                } else if (horizontal instanceof Trailing) {
                    trailing = (Trailing)horizontal;
                    size = trailing.getSize();
                    w2 = size == -1 ? prefs.width : size;
                    x2 = width - trailing.getTrailing() - w2 - insets.right;
                }
                if (vertical instanceof Leading) {
                    leading = (Leading)vertical;
                    y2 = insets.top + leading.getLeading();
                    size = leading.getSize();
                    h2 = size == -1 ? prefs.height : size;
                } else if (vertical instanceof Bilateral) {
                    bilateral = (Bilateral)vertical;
                    y2 = insets.top + bilateral.getLeading();
                    h2 = height - y2 - bilateral.getTrailing() - insets.bottom;
                } else if (vertical instanceof Trailing) {
                    trailing = (Trailing)vertical;
                    size = trailing.getSize();
                    h2 = size == -1 ? prefs.height : size;
                    y2 = height - trailing.getTrailing() - h2 - insets.bottom;
                }
                comp.setBounds(x2, y2, w2, h2);
            }
            ++i2;
        }
    }

    private Constraints createConstraintsFor(Container parent, Component comp) {
        LayoutStyle style = LayoutStyle.getInstance();
        int gap = style.getContainerGap((JComponent)comp, 3, parent);
        Rectangle bounds = comp.getBounds();
        Spring spring = new Spring(gap, gap);
        Leading horizontal = new Leading(bounds.x, bounds.width, spring);
        gap = style.getContainerGap((JComponent)comp, 5, parent);
        spring = new Spring(gap, gap);
        Leading vertical = new Leading(bounds.y, bounds.height, spring);
        Constraints cons = new Constraints(horizontal, vertical);
        this.constraints.put(comp, cons);
        return cons;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        Insets insets = parent.getInsets();
        int i2 = 0;
        while (i2 < count) {
            Component comp = parent.getComponent(i2);
            if (comp != null) {
                Trailing trailing;
                int size;
                Leading leading;
                Dimension prefs = comp.getPreferredSize();
                Constraints cons = this.constraints.get(comp);
                if (cons == null) {
                    cons = this.createConstraintsFor(parent, comp);
                }
                Alignment horizontal = cons.getHorizontal();
                Alignment vertical = cons.getVertical();
                if (horizontal instanceof Bilateral) {
                    Bilateral bialteral = (Bilateral)horizontal;
                    if (bialteral.getLeading() + bialteral.getTrailing() + bialteral.getSpring().getMinimum() + insets.left + insets.right > width) {
                        width = bialteral.getLeading() + bialteral.getTrailing() + bialteral.getSpring().getMinimum() + insets.left + insets.right;
                    }
                } else if (horizontal instanceof Leading) {
                    leading = (Leading)horizontal;
                    int n2 = size = leading.getSize() == -1 ? prefs.width : leading.getSize();
                    if (leading.getLeading() + size + leading.getSpring().getMinimum() + insets.left + insets.right > width) {
                        width = leading.getLeading() + size + leading.getSpring().getMinimum() + insets.left + insets.right;
                    }
                } else if (horizontal instanceof Trailing) {
                    trailing = (Trailing)horizontal;
                    int n3 = size = trailing.getSize() == -1 ? prefs.width : trailing.getSize();
                    if (trailing.getTrailing() + size + trailing.getSpring().getMinimum() + insets.left + insets.right > width) {
                        width = trailing.getTrailing() + size + trailing.getSpring().getMinimum() + insets.left + insets.right;
                    }
                }
                if (vertical instanceof Bilateral) {
                    Bilateral bilateral = (Bilateral)vertical;
                    if (bilateral.getLeading() + bilateral.getTrailing() + bilateral.getSpring().getMinimum() + insets.top + insets.bottom > height) {
                        height = bilateral.getLeading() + bilateral.getTrailing() + bilateral.getSpring().getMinimum() + insets.top + insets.bottom;
                    }
                } else if (vertical instanceof Leading) {
                    leading = (Leading)vertical;
                    int n4 = size = leading.getSize() == -1 ? prefs.height : leading.getSize();
                    if (leading.getLeading() + size + leading.getSpring().getMinimum() + insets.top + insets.bottom > height) {
                        height = leading.getLeading() + size + leading.getSpring().getMinimum() + insets.top + insets.bottom;
                    }
                } else if (vertical instanceof Trailing) {
                    trailing = (Trailing)vertical;
                    int n5 = size = trailing.getSize() == -1 ? prefs.height : trailing.getSize();
                    if (trailing.getTrailing() + size + trailing.getSpring().getMinimum() + insets.top + insets.bottom > height) {
                        height = trailing.getTrailing() + size + trailing.getSpring().getMinimum() + insets.top + insets.bottom;
                    }
                }
            }
            ++i2;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        Insets insets = parent.getInsets();
        int i2 = 0;
        while (i2 < count) {
            Component comp = parent.getComponent(i2);
            if (comp != null) {
                Trailing trailing;
                int size;
                Leading leading;
                int pref;
                Bilateral bilateral;
                Dimension prefs = comp.getPreferredSize();
                Constraints cons = this.constraints.get(comp);
                if (cons == null) {
                    cons = this.createConstraintsFor(parent, comp);
                }
                Alignment horizontal = cons.getHorizontal();
                Alignment vertical = cons.getVertical();
                if (horizontal instanceof Bilateral) {
                    bilateral = (Bilateral)horizontal;
                    pref = bilateral.getSpring().getPreferred();
                    int n2 = pref = pref == -1 ? prefs.width : pref;
                    if (bilateral.getLeading() + bilateral.getTrailing() + pref + insets.left + insets.right > width) {
                        width = bilateral.getLeading() + bilateral.getTrailing() + pref + insets.left + insets.right;
                    }
                } else if (horizontal instanceof Leading) {
                    leading = (Leading)horizontal;
                    int n3 = size = leading.getSize() == -1 ? prefs.width : leading.getSize();
                    if (leading.getLeading() + size + leading.getSpring().getPreferred() + insets.left + insets.right > width) {
                        width = leading.getLeading() + size + leading.getSpring().getPreferred() + insets.left + insets.right;
                    }
                } else if (horizontal instanceof Trailing) {
                    trailing = (Trailing)horizontal;
                    int n4 = size = trailing.getSize() == -1 ? prefs.width : trailing.getSize();
                    if (trailing.getTrailing() + size + trailing.getSpring().getPreferred() + insets.left + insets.right > width) {
                        width = trailing.getTrailing() + size + trailing.getSpring().getPreferred() + insets.left + insets.right;
                    }
                }
                if (vertical instanceof Bilateral) {
                    bilateral = (Bilateral)vertical;
                    pref = bilateral.getSpring().getPreferred();
                    int n5 = pref = pref == -1 ? prefs.height : pref;
                    if (bilateral.getLeading() + bilateral.getTrailing() + pref + insets.top + insets.bottom > height) {
                        height = bilateral.getLeading() + bilateral.getTrailing() + pref + insets.top + insets.bottom;
                    }
                } else if (vertical instanceof Leading) {
                    leading = (Leading)vertical;
                    int n6 = size = leading.getSize() == -1 ? prefs.height : leading.getSize();
                    if (leading.getLeading() + size + leading.getSpring().getPreferred() + insets.top + insets.bottom > height) {
                        height = leading.getLeading() + size + leading.getSpring().getPreferred() + insets.top + insets.bottom;
                    }
                } else if (vertical instanceof Trailing) {
                    trailing = (Trailing)vertical;
                    int n7 = size = trailing.getSize() == -1 ? prefs.height : trailing.getSize();
                    if (trailing.getTrailing() + size + trailing.getSpring().getPreferred() + insets.top + insets.bottom > height) {
                        height = trailing.getTrailing() + size + trailing.getSpring().getPreferred() + insets.top + insets.bottom;
                    }
                }
            }
            ++i2;
        }
        return new Dimension(width, height);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }
}

